/*
 * Decompiled with CFR 0.152.
 */
package android.smartcardio.ipc;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.smartcardio.TerminalFactory;
import android.smartcardio.ipc.IBackendIPC;
import android.smartcardio.ipc.ICardService;
import android.util.Log;
import java.nio.channels.NotYetBoundException;

public class CardService
implements ICardService {
    private static final String TAG = "TheobromaCardService";
    private final String intentAction = "com.theobroma.cardreadermanager.backendipc";
    private boolean isAvailable;
    private Context parent;
    public IBackendIPC cardService;
    public CardServiceConnection cardConnection;
    private static ICardService service;

    public static ICardService getInstance(Context parent) {
        if (service == null) {
            service = new CardService(parent);
        }
        return service;
    }

    private CardService(Context parent) {
        this.parent = parent;
        this.bindToService();
    }

    @Override
    public void bindToService() {
        this.cardConnection = new CardServiceConnection();
        Intent intent = new Intent("com.theobroma.cardreadermanager.backendipc");
        this.parent.startService(intent);
        this.isAvailable = this.parent.bindService(intent, (ServiceConnection)this.cardConnection, 1);
        if (this.isAvailable) {
            Log.d((String)TAG, (String)"Bound to Service. Action:com.theobroma.cardreadermanager.backendipc");
        } else {
            Log.e((String)TAG, (String)"Unable to bind to Service. Action:com.theobroma.cardreadermanager.backendipc");
        }
    }

    @Override
    public void releaseService() {
        if (this.cardConnection != null) {
            this.parent.unbindService((ServiceConnection)this.cardConnection);
            this.cardConnection = null;
        }
        Log.d((String)TAG, (String)"releaseService() unbound");
    }

    @Override
    public TerminalFactory getTerminalFactory() throws Exception {
        TerminalFactory factory = null;
        if (this.cardService == null) {
            throw new NotYetBoundException();
        }
        if (!this.isAvailable) {
            Log.e((String)TAG, (String)"No connection to Theobroma Card Service");
            throw new Exception("No connection to Theobroma Card Service");
        }
        factory = TerminalFactory.getDefault();
        factory.setCardService(this.cardService);
        return factory;
    }

    class CardServiceConnection
    implements ServiceConnection {
        CardServiceConnection() {
        }

        public void onServiceConnected(ComponentName className, IBinder binder) {
            CardService.this.cardService = IBackendIPC.Stub.asInterface(binder);
            Log.d((String)CardService.TAG, (String)"onServiceConnected");
        }

        public void onServiceDisconnected(ComponentName className) {
            CardService.this.cardService = null;
            Log.d((String)CardService.TAG, (String)"onServiceDisconnected");
        }
    }
}

