/*
 * Decompiled with CFR 0.152.
 */
package android.smartcardio.theobroma;

import android.os.RemoteException;
import android.smartcardio.ATR;
import android.smartcardio.Card;
import android.smartcardio.CardChannel;
import android.smartcardio.CardException;
import android.smartcardio.CardNotPresentException;
import android.smartcardio.ipc.ITheobromaJNI;
import android.smartcardio.theobroma.TheobromaCardChannel;

final class TheobromaCard
extends Card {
    private static final String TAG = "TheobromaCard";
    private ITheobromaJNI theobromaJni;
    private final ATR atr;
    private final TheobromaCardChannel basicChannel;
    private final long cardHandle;
    private final int protocolId;
    private volatile boolean isConnected = true;

    public TheobromaCard(long cardHandle, int protocolId, ATR atr, ITheobromaJNI theobromaJni) {
        this.atr = atr;
        this.basicChannel = new TheobromaCardChannel(this, 0);
        this.cardHandle = cardHandle;
        this.protocolId = protocolId;
        this.theobromaJni = theobromaJni;
    }

    @Override
    public ATR getATR() {
        return this.atr;
    }

    @Override
    public String getProtocol() {
        switch (this.protocolId) {
            case 1: {
                return "T=0";
            }
            case 2: {
                return "T=1";
            }
        }
        return "unknown protocol";
    }

    @Override
    public CardChannel getBasicChannel() {
        this.assertCardConnected();
        return this.basicChannel;
    }

    @Override
    public CardChannel openLogicalChannel() throws CardException {
        this.assertCardConnected();
        byte[] byArray = new byte[5];
        byArray[1] = 112;
        byArray[4] = 1;
        byte[] manageChannelCommand = byArray;
        byte[] rsp = this.transmit(manageChannelCommand, 3, 36864, 65535, "MANAGE CHANNEL");
        if (rsp.length != 3) {
            throw new CardException("openLogicalChannel: unsupported MANAGE CHANNEL response data");
        }
        int channelNumber = rsp[0] & 0xFF;
        if (channelNumber == 0 || channelNumber > 19) {
            throw new CardException("openLogicalChannel: invalid logical channel number returned");
        }
        TheobromaCardChannel channel = new TheobromaCardChannel(this, channelNumber);
        return channel;
    }

    @Override
    public void beginExclusive() throws CardException {
        this.assertCardConnected();
        this.internalBeginExclusive();
    }

    @Override
    public void endExclusive() throws CardException {
        this.assertCardConnected();
        this.internalEndExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transmitControlCommand(int controlCode, byte[] command) throws CardException {
        if (command == null) {
            throw new NullPointerException();
        }
        this.assertCardConnected();
        TheobromaCard theobromaCard = this;
        synchronized (theobromaCard) {
            return this.internalControl(controlCode, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean reset) throws CardException {
        if (!this.isConnected) {
            return;
        }
        try {
            TheobromaCard theobromaCard = this;
            synchronized (theobromaCard) {
                this.assertEndExclusive();
                this.internalDisconnect(reset);
            }
        }
        finally {
            this.isConnected = false;
        }
    }

    boolean isConnected(String protocol) throws CardException {
        if (this.isConnected()) {
            if (!protocol.equals("*") && !protocol.equals(this.getProtocol())) {
                throw new CardException("card connected with incombatible protocol " + this.getProtocol());
            }
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void finalize() throws Throwable {
        try {
            try {
                this.assertEndExclusive();
                this.internalDisconnect(true);
            }
            catch (Exception exception) {
                super.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }

    byte[] transmit(byte[] cmd, int minRspLength, int swExpected, int swMask) throws CardException {
        return this.transmit(cmd, minRspLength, swExpected, swMask, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] transmit(byte[] cmd, int minRspLength, int swExpected, int swMask, String commandName) throws CardException {
        byte[] rsp = null;
        try {
            TheobromaCard theobromaCard = this;
            synchronized (theobromaCard) {
                rsp = this.internalTransmit(cmd);
            }
        }
        catch (CardNotPresentException e) {
            throw e;
        }
        catch (CardException e) {
            if (commandName == null) {
                throw e;
            }
            throw new CardException(String.valueOf(commandName) + ": transmit failed", e);
        }
        if (minRspLength > 0 && (rsp == null || rsp.length < minRspLength)) {
            throw new CardException(String.valueOf(commandName) + ": response too small");
        }
        if (swMask != 0) {
            if (rsp == null || rsp.length < 2) {
                throw new CardException(String.valueOf(commandName) + ": SW1/2 not available");
            }
            int sw1 = rsp[rsp.length - 2] & 0xFF;
            int sw2 = rsp[rsp.length - 1] & 0xFF;
            int sw = sw1 << 8 | sw2;
            if ((sw & swMask) != (swExpected & swMask)) {
                throw new CardException(String.valueOf(commandName) + Integer.toHexString(sw));
            }
        }
        return rsp;
    }

    private byte[] internalControl(int controlCode, byte[] command) throws CardException {
        try {
            byte[] rsp = this.theobromaJni.control(this.cardHandle, controlCode, command);
            if (rsp == null) {
                throw new CardException("internalControl: got no response");
            }
            return rsp;
        }
        catch (RemoteException e) {
            throw new CardException("control command failed", e);
        }
    }

    private byte[] internalTransmit(byte[] command) throws CardException {
        try {
            byte[] rsp = this.theobromaJni.transmit(this.cardHandle, this.protocolId, command);
            if (rsp == null) {
                throw new CardException("internalTransmit: got no response");
            }
            return rsp;
        }
        catch (RemoteException e) {
            throw new CardException("transmit failed", e);
        }
    }

    private void internalDisconnect(boolean reset) throws CardException {
        try {
            switch (this.theobromaJni.disconnect(this.cardHandle)) {
                case -1: {
                    throw new CardException("invalid reader id");
                }
                case -2: {
                    throw new CardException("unable to power off icc");
                }
            }
        }
        catch (RemoteException e) {
            throw new CardException("card disconnect operation failed, card assumed to be disconnected", e);
        }
    }

    private void internalBeginExclusive() throws CardException {
        try {
            if (!this.theobromaJni.beginTransaction(this.cardHandle)) {
                throw new CardException("car currently owned by other thread");
            }
        }
        catch (RemoteException e) {
            throw new CardException("begin exclusive failed", e);
        }
    }

    private void internalEndExclusive() throws CardException {
        try {
            if (!this.theobromaJni.endTransaction(this.cardHandle)) {
                throw new IllegalStateException("different exclusive owner");
            }
        }
        catch (RemoteException e) {
            throw new CardException("end exclusive failed", e);
        }
    }

    private void assertCardConnected() {
        if (!this.isConnected) {
            throw new IllegalStateException("card is disposed");
        }
    }

    private void assertEndExclusive() {
        try {
            this.internalEndExclusive();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (CardException cardException) {
            // empty catch block
        }
    }
}

