/*
 * Decompiled with CFR 0.152.
 */
package android.smartcardio.theobroma;

import android.os.RemoteException;
import android.smartcardio.ATR;
import android.smartcardio.Card;
import android.smartcardio.CardException;
import android.smartcardio.CardNotPresentException;
import android.smartcardio.CardTerminal;
import android.smartcardio.ipc.ITheobromaJNI;
import android.smartcardio.theobroma.TheobromaCard;

final class TheobromaCardTerminal
extends CardTerminal {
    private static final String TAG = "TheobromaCardTerminal";
    private final long contextHandle;
    private ITheobromaJNI theobromaJni;
    private final String name;
    private volatile TheobromaCard card;

    public TheobromaCardTerminal(long contextHandle, String name, ITheobromaJNI theobromaJni) {
        this.contextHandle = contextHandle;
        this.theobromaJni = theobromaJni;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Card connect(String protocol) throws CardException {
        if (protocol == null) {
            throw new NullPointerException("connect: protocol mustn't be null");
        }
        if (!(protocol.equals("T=0") || protocol.equals("T=1") || protocol.equals("*"))) {
            throw new IllegalArgumentException("connect: unsupported protocol " + protocol);
        }
        if (!this.isCardPresent()) {
            throw new CardNotPresentException("no card present");
        }
        TheobromaCardTerminal theobromaCardTerminal = this;
        synchronized (theobromaCardTerminal) {
            if (this.card != null) {
                if (this.card.isConnected(protocol)) {
                    return this.card;
                }
                this.card = null;
            }
            this.card = this.internalConnect(protocol);
            return this.card;
        }
    }

    @Override
    public boolean isCardPresent() throws CardException {
        return this.internalWaitForCard(1L, true);
    }

    @Override
    public boolean waitForCardPresent(long timeout) throws CardException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        return this.internalWaitForCard(timeout, true);
    }

    @Override
    public boolean waitForCardAbsent(long timeout) throws CardException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        return this.internalWaitForCard(timeout, false);
    }

    private TheobromaCard internalConnect(String protocol) throws CardException {
        int protocolId = this.getProtocolId(protocol);
        int selectedProtocolId = 0;
        long cardHandle = 0L;
        try {
            cardHandle = this.theobromaJni.connect(this.contextHandle, this.name, 2);
            switch ((int)cardHandle) {
                case -3: {
                    throw new CardException("invalid context id");
                }
                case -4: {
                    throw new CardException("reader name not found");
                }
                case -5: {
                    throw new CardNotPresentException("no card present");
                }
                case -6: {
                    throw new CardException("reader currently in exclusive use");
                }
            }
        }
        catch (RemoteException e) {
            throw new CardException("internalConnect", e);
        }
        try {
            byte[] atr = this.theobromaJni.powerOn(cardHandle);
            if (atr == null) {
                throw new CardException("internalConnect: cannot get ATR");
            }
            selectedProtocolId = this.theobromaJni.setProtocol(cardHandle, protocolId);
            if (selectedProtocolId < 0) {
                this.theobromaJni.disconnect(cardHandle);
            }
            switch (selectedProtocolId) {
                case -1: {
                    throw new CardException("reader id not found");
                }
                case -7: {
                    throw new CardException("protocol " + protocol + " not supported");
                }
            }
            return new TheobromaCard(cardHandle, selectedProtocolId, new ATR(atr), this.theobromaJni);
        }
        catch (RemoteException e) {
            try {
                if (this.theobromaJni.disconnect(cardHandle) < 0) {
                    throw new CardException("unable to disconnect card");
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            throw new CardException("ATR not available", e);
        }
    }

    private int getProtocolId(String protocol) {
        if (protocol.equals("*")) {
            return 3;
        }
        if (protocol.equals("T=0")) {
            return 1;
        }
        if (protocol.equals("T=1")) {
            return 2;
        }
        throw new IllegalArgumentException("protocol " + protocol + " invalid or not supported");
    }

    private boolean internalWaitForCard(long timeout, boolean present) throws CardException {
        try {
            int[] currentStates = new int[]{-1};
            int[] expectedStates = new int[]{present ? 2 : 3};
            String[] readerNames = new String[]{this.name};
            int[] newStates = this.theobromaJni.waitForChange(this.contextHandle, (int)timeout, currentStates, expectedStates, readerNames);
            if (newStates == null) {
                throw new CardException("internalWaitForCard: cannot get reader status");
            }
            return newStates[0] == expectedStates[0];
        }
        catch (RemoteException e) {
            throw new CardException("internalWaitForCard", e);
        }
    }
}

